﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using IndianHealthService.BMXNet.Services;


namespace IndianHealthService.BMXNet.Tools.ComponentTestBench
{
    public partial class LogTranscriptControl : UserControl,Log
    {
        public LogTranscriptControl()
        {
            InitializeComponent();
        }


        private bool _isLogging = true;

        public bool IsLogging
        {
            get { return _isLogging; }
            set { _isLogging = value; }
        }

        public delegate void UiLogDelegate(string aClass, string aCategory, params string[] lines);
       
        
        public void Log(string aClass, string aCategory, params string[] lines)
        {
            if (!this.IsLogging)
            {
                return;
            }

       //     if (this.InvokeRequired)
         //   {
         //       this.Invoke(new UiLogDelegate(this.UiLog), aClass, aCategory, lines);
        //    }
      //      else
       //     {
                this.UiLog(aClass, aCategory, lines);
       //     }

        }
     
        protected void UiLog(string aClass, string aCategory, params string[] lines) {
     
         
            this.transcriptBox.AppendText("\r\n-------------------\r\n");
            this.transcriptBox.AppendText(DateTime.Now.ToString("HH:MM:ss.mm").PadRight(12)+" "+aClass.PadRight(12) + " " + aCategory.PadRight(12));
            if (lines.Length == 1)
            {
                this.transcriptBox.AppendText("   ");
                this.transcriptBox.AppendText(lines[0]);
            } else {

                for (int i=0;i<lines.Length;i++)
                {
                    this.transcriptBox.AppendText("\r\n");
                    this.transcriptBox.AppendText("[" + (i+1).ToString().PadLeft(2) + "]  ");
                    this.transcriptBox.AppendText(lines[i]);
                }
            }
        }

        public void Log(string aClass, string aCategory, Exception anException, params string[] lines)
        {
            if (!this.IsLogging)
            {
                return;
            }

            this.Log(aClass, aCategory, lines);
            this.transcriptBox.AppendText("#####");
            this.transcriptBox.AppendText(anException.Message);
            this.transcriptBox.AppendText("#####");
            this.transcriptBox.AppendText(anException.StackTrace);
        }

        private void LogTranscriptControl_Load(object sender, EventArgs e)
        {
            this.transcriptBox.ScrollBars = ScrollBars.Vertical;
            this.transcriptBox.WordWrap = true;
        }

    
    }
}
